<?php

namespace Iranserver\LaravelJaeger\Listeners;

use Illuminate\Database\Events\QueryExecuted;
use OpenTracing\Tracer;

class QueryListener
{
    private $tracer;
    public function __construct(Tracer $tracer)
    {
        $this->tracer = $tracer;
    }

    public function handle(QueryExecuted $event)
    {
        $span = $this->tracer->getActiveSpan();
        if (!$span) return;
        $span->log([
            'query.sql'             => $event->sql,
            'query.bindings'        => $event->bindings,
            'query.connection_name' => $event->connectionName,
            'query.time'            => $event->time
        ]);
    }
}
