<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Listeners;

use Illuminate\Queue\Events\JobProcessing;
use Iranserver\LaravelJaeger\Middleware\JobTracingMiddleware;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use Iranserver\LaravelJaeger\Services\TraceIdHeaderRetriever;
use Illuminate\Support\Facades\Config as ConfigRepository;
use Iranserver\LaravelJaeger\Services\Caller;
use OpenTracing\Reference;

class JobStartedListener
{
    private $spanCreator;
    private $traceIdHeaderRetriever;

    public function __construct(TraceIdHeaderRetriever $traceIdHeaderRetriever, SpanCreator $spanCreator)
    {
        $this->traceIdHeaderRetriever = $traceIdHeaderRetriever;
        $this->spanCreator            = $spanCreator;
    }

    public function handle(JobProcessing $job)
    {
        $payload = optional(unserialize($job->job->payload()['data']['command']))->{JobTracingMiddleware::JOB_TRACING_CONTEXT_FIELD};

        $traceIdHeader = $payload ? $this->traceIdHeaderRetriever->retrieve($payload) : null;

        $this->spanCreator->create(
            Caller::call(ConfigRepository::get('jaeger.job.span_name'), [$job->job]),
            $traceIdHeader,
            Reference::FOLLOWS_FROM
        );
    }
}
