<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Listeners;

use Illuminate\Console\Events\CommandStarting;
use Illuminate\Support\Facades\Config as ConfigRepository;
use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\ConsoleCommandFilter;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;

class ConsoleCommandStartedListener
{
    private $spanCreator;

    public function __construct(SpanCreator $spanCreator)
    {
        $this->spanCreator = $spanCreator;
    }

    public function handle(CommandStarting $event): void
    {
        /** @var ConsoleCommandFilter $filter */
        $filter = app(ConsoleCommandFilter::class);

        if ($filter->allow($event->command)){
            $this->spanCreator
                ->create(
                    Caller::call(ConfigRepository::get('jaeger.console.span_name'), [$event->command ?? 'empty', $event->input])
                );
        }
    }
}
