<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Listeners;

use Illuminate\Console\Events\CommandFinished;
use Illuminate\Support\Facades\Config;
use OpenTracing\Tracer;
use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\ConsoleCommandFilter;
use Iranserver\LaravelJaeger\Services\Span\SpanTagHelper;

class ConsoleCommandFinishedListener
{
    private $tracer;

    public function __construct(Tracer $tracer)
    {
        $this->tracer = $tracer;
    }

    public function handle(CommandFinished $event): void
    {
        /** @var ConsoleCommandFilter $filter */
        $filter = app(ConsoleCommandFilter::class);
        $span = $this->tracer->getActiveSpan();
        if (!$span or !$filter->allow($event->command)) {
            return;
        }

        $callableConfig = Config::get('jaeger.console.tags', function () {
            return [
                'type' => 'console',
            ];
        });

        SpanTagHelper::setTags(
            $span,
            Caller::call($callableConfig, [$event->command ?? 'empty', $event->exitCode, $event->input, $event->output])
        );

        optional($this->tracer->getScopeManager()->getActive())
            ->close();
        $this->tracer->flush();
    }
}
