<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Http;

use Illuminate\Http\Request;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class SpanNameResolver
{
    private $router;

    public function __construct(Router $router) {
        $this->router = $router;
    }

    public function __invoke(Request $request)
    {
        $httpMethod = $request->method();
        $uri        = $request->path();
        return Str::startsWith($uri, "/") ? "$httpMethod: $uri" : "$httpMethod: /$uri";
    }
}
