<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Listeners;

use Illuminate\Queue\Events\JobFailed;
use Iranserver\LaravelJaeger\Services\Span\SpanTagHelper;
use OpenTracing\Tracer;
use Iranserver\LaravelJaeger\Services\Caller;
use Illuminate\Support\Facades\Config as ConfigRepository;

class JobFinishedListener
{
    private $tracer;
    public function __construct(Tracer $tracer)
    {
        $this->tracer = $tracer;
    }

    public function handle($job)
    {
        $callableConfig = ConfigRepository::get('jaeger.job.tags', function () {
            return [
                'type' => 'job',
            ];
        });

        $activeSpan = $this->tracer->getActiveSpan();
        if (!$activeSpan) return;
        SpanTagHelper::setTags($activeSpan, Caller::call($callableConfig, [$job->job]));

        /** Log Into jaager if job failed */
        if ($job instanceof JobFailed){
            $activeSpan->log([
                'message' => $job->exception->getMessage(),
                'code' => $job->exception->getCode(),
                'line' => $job->exception->getLine(),
                'file' => $job->exception->getFile(),
            ]);
        }

        optional($this->tracer->getScopeManager()->getActive())->close();
        optional($this->tracer)->flush();
    }
}
