<?php

namespace Iranserver\LaravelJaeger\Traits;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Str;
use Iranserver\LaravelJaeger\Services\Span\ParentSpans;

trait JaegerFunctions
{
    private function jsonEncode($value): string
    {
        return json_encode($value, JSON_OBJECT_AS_ARRAY | JSON_BIGINT_AS_STRING | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    }

    private function jsonDecode($value)
    {
        return json_decode($value, true, 512, JSON_OBJECT_AS_ARRAY | JSON_BIGINT_AS_STRING | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    }

    private function loadParentSpans($jaeger): void
    {
        $jaeger = trim(strval($jaeger));
        if ($jaeger != '') {
            $parentSpans = (array)$this->jsonDecode($jaeger);
            if ($parentSpans != []) {
                ParentSpans::load($parentSpans);
            }
        }
    }

    private function filterValue(string $value, int $count = 3): string
    {
        $value = trim($value);
        $length = mb_strlen($value);
        $doubleCount = $count + $count;

        if ($length > $doubleCount) {
            $value = mb_substr($value, 0, $count) . str_repeat('-', $length - $doubleCount) . mb_substr($value, -$count);
        }

        return $value;
    }

    private function filterArray(array $array, array $keysToFilter, $parentKey = null): array
    {
        if ($array == [] || $keysToFilter == []) {
            return $array;
        }

        $finalArray = [];
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $finalArray[$key] = $this->filterArray($value, $keysToFilter, $key);
            } else if (Str::contains(mb_strtolower(strval($key)), $keysToFilter) || Str::contains(mb_strtolower(strval($parentKey)), $keysToFilter)) {
                $finalArray[$key] = $this->filterValue(strval($value));
            } else {
                $finalArray[$key] = $value;
            }
        }

        return $finalArray;
    }

    private function getFilterWords(): array
    {
        $filterWords = [];
        foreach (Config::get('jaeger.filter_words', []) as $filterWord) {
            $filterWords[] = mb_strtolower(strval($filterWord));
        }

        return $filterWords;
    }

    private function filterWordsInUrl(string $url): string
    {
        parse_str((parse_url($url)['query'] ?? ''), $query);
        $query = $this->filterArray($query, $this->getFilterWords());
        $query = http_build_query($query);

        return strtok($url, '?') . ($query != '' ? '?' . $query : '');
    }

    private function filterWordsInArray(array $array): array
    {
        return $this->filterArray($array, $this->getFilterWords());
    }
}