<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Services\Job;

use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;
use Iranserver\LaravelJaeger\Services\Span\ParentSpans;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use Iranserver\LaravelJaeger\Services\Span\SpanTagHelper;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;
use OpenTracing\Tracer;
use Illuminate\Support\Facades\Config;
use OpenTracing\Reference;

class JobInjectionMaker
{
    use JaegerFunctions;

    private $tracer;
    private $spanCreator;

    public function __construct(Tracer $tracer, SpanCreator $spanCreator)
    {
        $this->tracer = $tracer;
        $this->spanCreator = $spanCreator;
    }

    /**
     * @throws CallerException
     */
    public function injectParentSpanToCommand(object $command, string $methodName): object
    {
        if (!empty($command->jaeger)) {
            return $command;
        }

        $parentSpan = ParentSpans::get();

        if (!$parentSpan) {
            return $command;
        }

        $span = $this->spanCreator->create(
            Caller::call(Config::get('jaeger.dispatcher.span_name'), [$command, $methodName]),
            $parentSpan,
            Reference::CHILD_OF
        );

        ParentSpans::add($span);
        $command->jaeger = $this->jsonEncode(ParentSpans::all());
        ParentSpans::remove($span);

        SpanTagHelper::setTags(
            $span,
            Caller::call(Config::get('jaeger.dispatcher.tags'), [$command])
        );

        $span->finish();
        $this->tracer->flush();

        return $command;
    }
}
