<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Listeners\Console;

use Illuminate\Console\Events\CommandStarting;
use Illuminate\Support\Facades\Config as ConfigRepository;
use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\ConsoleCommandFilter;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;
use Iranserver\LaravelJaeger\Services\Span\ParentSpans;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use OpenTracing\Reference;
use OpenTracing\Span;

final class ConsoleCommandStartedListener
{
    private $filter;
    private $spanCreator;

    public function __construct(ConsoleCommandFilter $filter, SpanCreator $spanCreator)
    {
        $this->filter = $filter;
        $this->spanCreator = $spanCreator;
    }

    /**
     * @throws CallerException
     */
    public function handle(CommandStarting $event): void
    {
        if (!$this->filter->allow($event->command)) {
            return;
        }

        /** @var Span|null $parentSpan */
        $parentSpan = ParentSpans::get();

        $span = $this->spanCreator->create(
            Caller::call(ConfigRepository::get('jaeger.console.span_name'), [$event]),
            $parentSpan,
            Reference::CHILD_OF
        );

        ParentSpans::add($span);
    }
}
