<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Log;

use Illuminate\Log\Events\MessageLogged;

final class SpanNameResolver
{
    public function __invoke(MessageLogged $event): string
    {
        return '[Log] [' . ucfirst($event->level) . '] ' . $event->message;
    }
}
