<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\JobDispatcher;

use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class TagsResolver
{
    use JaegerFunctions;

    public function __invoke(object $command): array
    {
        $payload = $this->filterWordsInArray((array)$command);
        unset($payload['jaeger']);
        return [
            '#type'    => 'dispatcher',
            '-class'   => get_class($command),
            '-payload' => $this->jsonEncode($payload),
        ];
    }
}
