<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Job;

use Illuminate\Queue\Events\JobExceptionOccurred;
use Illuminate\Queue\Events\JobFailed;
use Illuminate\Queue\Events\JobProcessed;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class TagsResolver
{
    use JaegerFunctions;

    /**
     * @param JobProcessed|JobFailed|JobExceptionOccurred $event
     */
    public function __invoke($event): array
    {
        $payload = $this->filterWordsInArray($event->job->payload() ?? []);
        $jaeger = isset($payload['jaeger']) ? trim(strval($payload['jaeger'])) : '[]';
        unset($payload['jaeger']);
        return [
            '#type'            => 'job',
            '-max_tries'       => $event->job->maxTries() ?? 1,
            '-jaeger'          => $jaeger,
            '-class'           => $event->job->resolveName(),
            '-id'              => $event->job->getJobId(),
            '-connection_name' => $event->job->getConnectionName(),
            '-name'            => $event->job->getName(),
            '-queue'           => $event->job->getQueue(),
            '-attempts'        => $event->job->attempts() ?? 1,
            '-failed'          => $event->job->hasFailed(),
            '-payload'         => $this->jsonEncode($payload),
        ];
    }
}
