<?php

namespace Iranserver\LaravelJaeger\Services\Span;

use Jaeger\Span;
use Jaeger\SpanContext;
use OpenTracing\Tracer;

final class ParentSpans
{
    private static $parentSpans = [];

    public static function load(array $parentSpans): void
    {
        self::$parentSpans = $parentSpans;
    }

    public static function add(Span $parentSpan): void
    {
        $context = $parentSpan->getContext();
        $tags = [];
        $parentSpanTags = $parentSpan->getTags();
        isset($parentSpanTags['#env']) && $tags['e'] = $parentSpanTags['#env']->value;
        isset($parentSpanTags['#parent_id']) && $tags['pi'] = $parentSpanTags['#parent_id']->value;
        isset($parentSpanTags['#parent_title']) && $tags['pt'] = $parentSpanTags['#parent_title']->value;
        self::$parentSpans[] = [
            'on' => $parentSpan->getOperationName(),
            'ti' => $context->getTraceId(),
            'si' => $context->getSpanId(),
            'pi' => $context->getParentId(),
            'f'  => $context->getFlags(),
            't'  => $tags,
        ];
    }

    public static function get(): ?Span
    {
        $parentSpan = end(self::$parentSpans);
        if ($parentSpan === false) {
            return null;
        }
        $tags = [];
        $parentSpanTags = $parentSpan['t'];
        isset($parentSpanTags['e']) && $tags['#env'] = $parentSpanTags['e'];
        isset($parentSpanTags['pi']) && $tags['#parent_id'] = $parentSpanTags['pi'];
        isset($parentSpanTags['pt']) && $tags['#parent_title'] = $parentSpanTags['pt'];
        return new Span(
            new SpanContext($parentSpan['ti'], $parentSpan['si'], $parentSpan['pi'], $parentSpan['f']),
            app(Tracer::class),
            $parentSpan['on'],
            $tags
        );
    }

    public static function remove(Span $parentSpan): void
    {
        /** @var array|false $lastSpan */
        $lastSpan = end(self::$parentSpans);
        if ($lastSpan !== false && $lastSpan['si'] === $parentSpan->getContext()->getSpanId()) {
            array_pop(self::$parentSpans);
        }
    }

    public static function all(): array
    {
        return self::$parentSpans;
    }
}