<?php

namespace Iranserver\LaravelJaeger\Services\Guzzle;

use Illuminate\Http\Client\PendingRequest;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Str;
use Iranserver\LaravelJaeger\Services\Span\ParentSpans;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class CustomPendingRequest extends PendingRequest
{
    use JaegerFunctions;

    protected function sendRequest(string $method, string $url, array $options = [])
    {
        $allowedDomains = Config::get('jaeger.guzzle.allowed_domains', []);
        if (Str::startsWith($url, $allowedDomains)) {
            $options['headers']['X-JAEGER'] = $this->jsonEncode(ParentSpans::all());
        }

        return parent::sendRequest($method, $url, $options);
    }
}