<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Log;

use Illuminate\Log\Events\MessageLogged;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class TagsResolver
{
    use JaegerFunctions;

    public function __invoke(MessageLogged $event): array
    {
        return [
            '#type'    => 'log',
            '-level'   => $event->level,
            '-message' => $event->message,
            '-context' => $this->jsonEncode($this->filterWordsInArray($event->context)),
        ];
    }
}
