<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Guzzle;

use Illuminate\Http\Client\Events\RequestSending;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class TagsResolver
{
    use JaegerFunctions;

    public function __invoke(RequestSending $event): array
    {
        return [
            '#type'   => 'guzzle',
            '-method' => $event->request->method(),
            '-url'    => $this->filterWordsInUrl($event->request->url()),
            '-body'   => $this->jsonEncode($this->filterWordsInArray($event->request->data() ?? [])),
            '-header' => $this->jsonEncode($this->filterWordsInArray($event->request->headers() ?? [])),
        ];
    }
}
