<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Guzzle;

use Illuminate\Http\Client\Events\RequestSending;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class SpanNameResolver
{
    use JaegerFunctions;

    public function __invoke(RequestSending $event): string
    {
        return '[Guzzle] [' . $event->request->method() . '] ' . $this->filterWordsInUrl($event->request->url());
    }
}
