<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Console;

use Illuminate\Console\Events\CommandFinished;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class TagsResolver
{
    use JaegerFunctions;

    public function __invoke(CommandFinished $event): array
    {
        $arguments = $event->input->getArguments();
        unset($arguments['command'], $arguments[0]);
        return [
            '#type'      => 'console',
            '-command'   => $event->command,
            '-exit_code' => $event->exitCode,
            '-arguments' => $this->jsonEncode($this->filterWordsInArray($arguments)),
            '-options'   => $this->jsonEncode($this->filterWordsInArray($event->input->getOptions())),
        ];
    }
}
