<?php

namespace Iranserver\Jobs\Sms;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseCancelSmsJob extends BaseJob
{
    /**
     * @var UserInterface $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public UserInterface $user;
    public InfoInterface $info;

    public function __construct(UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('sms.cmd.canceled');

        $this->user = $user;
        $this->info = $info;
    }

    public function handle(){}
}
