<?php

namespace Iranserver\Jobs\Hosting;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Base\Hosting;
use Iranserver\Models\Base\Server;
use Iranserver\Models\Interfaces\UserInterface;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseSuspendHosting extends BaseJob
{
    public Hosting $hosting;
    public Server $server;
    public InfoInterface $info;
    public UserInterface $user;

    public function __construct(Hosting $hosting, Server $server, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION', 'rabbitmq'));

        $this->hosting = $hosting;
        $this->server = $server;
        $this->info = $info;
        $this->user = $user;

    }

    public function handle()
    {
    }
}