<?php

namespace Iranserver\Jobs\Email;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\MessageInterface;


abstract class BaseSendMailJob extends BaseJob
{
    /**
     * @var array $user
     * @var MessageInterface $message
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public array $user;
    public MessageInterface $message;
    public InfoInterface $info;

    public function __construct(array $user,MessageInterface $message, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('mail.cmd.send');

        $this->user = $user;
        $this->message = $message;
        $this->info = $info;
    }

    public function handle(){}
}
