<?php

namespace Iranserver\Events\User;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;
use function Iranserver\Jobs\Base\Sms\env;

class UserUpdatedEvent extends BaseJob
{
    /**
     * @var UserInterface $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public UserInterface $user;
    public InfoInterface $info;

    public function __construct(UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('user.event.updated');

        $this->user = $user;
        $this->info = $info;
    }
}
