<?php

namespace Iranserver\Events\User;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;


class UserLoginFailedEvent extends BaseJob
{
    public string $username;
    public InfoInterface $info;

    public function __construct($username, InfoInterface $info = null)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('user.event.login-failed');

        $this->username = $username;
        $this->info = $info;
    }
}