<?php

namespace Iranserver\Events\Ticket;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\TicketInterface;
use Iranserver\Models\Interfaces\UserInterface;


class TicketRepliedEvent extends BaseJob
{
    public TicketInterface $ticket;
    public ?UserInterface $user;
    public InfoInterface $info;

    /**
     * @var TicketInterface $ticket
     * @var ?UserInterface $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public function __construct(TicketInterface $ticket, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('ticket.event.replied');

        $this->ticket  = $ticket;
        $this->user    = $user;
        $this->info    = $info;
    }
}
