<?php

namespace Iranserver\Events\Credit;

use Iranserver\Jobs\BaseJob;

class WebserviceUnderfundingUpcomingEvent extends BaseJob
{
    public string $providerName;
    public array $data;

    /**
     * @var string $providerName
     * @var array $data
     *
     * Hold credit parameters.
     */
    public function __construct(string $providerName,array $data)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('webservice.event.underfunding');

        $this->providerName = $providerName;
        $this->data         = $data;
    }

    public function handle(){}
}
