<?php

namespace Iranserver\Jobs\Base\User;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseSingleSmsJob extends BaseJob
{
    /**
     * @var UserInterface $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public UserInterface $user;
    public InfoInterface $info;

    public function __construct(UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));

        $this->user = $user;
        $this->info = $info;
    }

    public function handle(){}
}
