<?php

namespace Iranserver\Events\Ssl;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

class SslSuspendedEvent extends BaseJob
{
    public InfoInterface $info;
    public $service_id;

    public function __construct(int $service_id, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('ssl.event.suspended');

        $this->service_id = $service_id;
        $this->info = $info;
    }
}
