<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\HostingInterface;
use Iranserver\Models\Interfaces\InfoInterface;


class HostingDiskFullEvent extends BaseJob
{
    public HostingInterface $hosting;
    public InfoInterface $info;

    public function __construct(HostingInterface $hosting, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.event.disk-full');
        $this->hosting = $hosting;
        $this->info = $info;

    }

}
