<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseOpenstackServerResizeJob extends BaseJob
{
    /**
     * @var int $service_id
     * @var string $new_flavor_id
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public int $service_id;
    public string $new_flavor_id;
    public string $default_traffic;
    public InfoInterface $info;

    public int $tries = 3;

    /**
     * Calculate the number of seconds to wait before retrying the job.
     */
    public function backoff(): int
    {
        return 60;
    }

    public function __construct(int $service_id, string $new_flavor_id, string $default_traffic, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('openstack.cmd.resize');

        $this->service_id = $service_id;
        $this->new_flavor_id = $new_flavor_id;
        $this->default_traffic = $default_traffic;
        $this->info = $info;
    }

    public function handle()
    {
    }
}