<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\SnapshotInterface;
use Iranserver\Models\Interfaces\UserInterface;
use Iranserver\RabbitMQ\AutoResolve;

#[AutoResolve('user', 'snapshot')]
class SnapshotDeletionFailedEvent extends BaseJob
{
    public bool $dispatch_from_cron;
    public SnapshotInterface $snapshot;
    public ?UserInterface $user;
    public InfoInterface $info;
    public string $reason;

    /**
     * @param bool $dispatch_from_cron
     * @param SnapshotInterface $snapshot
     * @param string $reason
     * @param UserInterface|null $user
     * @param InfoInterface $info
     */
    public function __construct(bool $dispatch_from_cron, SnapshotInterface $snapshot, string $reason, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('snapshot.event.delete-failed');

        $this->dispatch_from_cron = $dispatch_from_cron;
        $this->snapshot = $snapshot;
        $this->user = $user;
        $this->info = $info;
        $this->reason = $reason;
    }
}
