<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ProductInterface;

class PreCreateServerEvent extends BaseJob
{
    public function __construct(
        public int $service_id,
        public int $product_id,
        public string $server_name,
        public string $image_name,
        public InfoInterface $info,
    )
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('openstack.event.pre-create');
    }
}