<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenstackInterface;


class OpenstackPasswordChangedEvent extends BaseJob
{
    public OpenstackInterface $openstackService;
    public string $password;
    public InfoInterface $info;

    /**
     * @param OpenstackInterface $openstackService
     * @param string $password
     * @param InfoInterface $info
     */
    public function __construct(OpenstackInterface $openstackService, string $password, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('openstack.event.password-changed');

        $this->openstackService = $openstackService;
        $this->password = $password;
        $this->info = $info;
    }
}
