<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenStack\ImageInterface;

final class ImageReinstallationFailedEvent extends BaseJob
{
    public int $service_id;
    public ImageInterface $image;
    public string $reason;
    public InfoInterface $info;

    /**
     * @param int $service_id Hub Host ID
     * @param ImageInterface $image
     * @param string $reason Error
     * @param InfoInterface $info
     */
    public function __construct(int $service_id, ImageInterface $image, string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('image.event.reinstallation-failed');

        $this->service_id = $service_id;
        $this->image = $image;
        $this->reason = $reason;
        $this->info = $info;
    }
}
