<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

final class IncompatibleImagesUpdatedEvent extends BaseJob
{
    public int $datacenter_id;
    public string $flavor_uuid;
    public array $incompatible_image_uuids;
    public InfoInterface $info;

    /**
     * @param int $datacenter_id DataCenter ID
     * @param string $flavor_uuid Flavor UUID
     * @param string[] $incompatible_image_uuids Incompatible Image UUIDs
     * @param InfoInterface $info
     */
    public function __construct(int $datacenter_id, string $flavor_uuid, array $incompatible_image_uuids, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('incompatible_images.event.updated');

        $this->datacenter_id = $datacenter_id;
        $this->flavor_uuid = $flavor_uuid;
        $this->incompatible_image_uuids = $incompatible_image_uuids;
        $this->info = $info;
    }
}
