<?php

namespace Iranserver\Jobs\Service;

use Exception;
use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseServiceUnSuspendJob extends BaseJob
{
    public int $service_id;
    public string $service_type;
    public InfoInterface $info;

    public function __construct(int $service_id, string $service_type, InfoInterface $info)
    {
        throw_if(!in_array($service_type, ['Addon', 'Product']), Exception::class, 'Service type should be one of "Product" or "Service"');
        $this->onConnection('rabbitmq');
        $this->onQueue('service.cmd.unsuspend');

        $this->service_id = $service_id;
        $this->service_type = $service_type;
        $this->info = $info;
    }

    public function handle()
    {
    }
}
