<?php

namespace Iranserver\Events\User;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

class ApiTokenRevokeFailedEvent extends BaseJob
{
    /**
     * @var int $user_id
     * @var string $reason
     * @var InfoInterface $info
     */
    public int $user_id;
    public string $reason;
    public InfoInterface $info;

    public function __construct(int $user_id , string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('api.event.revoke-failed');

        $this->user_id = $user_id;
        $this->reason = $reason;
        $this->info = $info;
    }
}