<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenstackInterface;


class UpdateCycleFailedEvent extends BaseJob
{
    public OpenstackInterface $openstackService;
    public InfoInterface $info;
    public string $reason;

    /**
     * @var OpenstackInterface $openstackService
     * @param InfoInterface $info
     *
     * Hold invoice parameters.
     *
     */
    public function __construct(OpenstackInterface $openstackService ,string $reason ,InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('openstack.event.updatecycle-failed');

        $this->openstackService = $openstackService;
        $this->reason = $reason;
        $this->info = $info;
    }
}
