<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenstackInterface;


class OpenstackPasswordChangeFailedEvent extends BaseJob
{
    public OpenstackInterface $openstackService;
    public string $reason;
    public InfoInterface $info;

    /**
     * @param OpenstackInterface $openstackService
     * @param string $reason
     * @param InfoInterface $info
     */
    public function __construct(OpenstackInterface $openstackService, string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('openstack.event.password-change-failed');

        $this->openstackService = $openstackService;
        $this->reason = $reason;
        $this->info = $info;
    }
}
