<?php

namespace Iranserver\Events\User;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

class ApiTokenRevokedEvent extends BaseJob
{
    /**
     * @var int $user_id
     * @var InfoInterface $info
     */
    public int $user_id;
    public InfoInterface $info;

    public function __construct(int $user_id, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('api.event.revoked');

        $this->user_id = $user_id;
        $this->info = $info;
    }
}