<?php

namespace Iranserver\Events\Ssl;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

class SslSuspendFailedEvent extends BaseJob
{
    public InfoInterface $info;
    public int $service_id;
    public string $reason;

    public function __construct(int $service_id, string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('ssl.event.suspend-failed');

        $this->service_id = $service_id;
        $this->reason = $reason;
        $this->info = $info;

    }

    public function handle() {}
}