<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenstackInterface;


class OpenstackActionFailedEvent extends BaseJob
{
    public OpenstackInterface $openstackService;
    public string $action;
    public string $reason;
    public InfoInterface $info;

    /**
     * @param OpenstackInterface $openstackService
     * @param string $action
     * @param string $reason
     * @param InfoInterface $info
     */
    public function __construct(OpenstackInterface $openstackService, string $action, string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('openstack.event.action-failed');

        $this->openstackService = $openstackService;
        $this->action = $action;
        $this->reason = $reason;
        $this->info = $info;
    }
}
