<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\HostingInterface;
use Iranserver\Models\Interfaces\InfoInterface;


class HostingDiskSpaceLimitExceededEvent extends BaseJob
{
    public HostingInterface $hosting;
    public string $usage;
    public InfoInterface $info;

    public function __construct(HostingInterface $hosting, string $usage, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.event.disk-usage-warning');
        $this->hosting = $hosting;
        $this->usage = $usage;
        $this->info = $info;

    }

}
