<?php

namespace Iranserver\Jobs;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\HostingDTO;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseCreateHosting extends BaseJob
{
    public HostingDTO $hostingDTO;
    public InfoInterface $info;
    public UserInterface $user;

    public function __construct(HostingDTO $hostingDTO, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.cmd.create');

        $this->hostingDTO = $hostingDTO;
        $this->info = $info;
        $this->user = $user;

    }

    public function handle(){}
}