<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;


class HostingCreatedEvent extends BaseJob
{
    public int $service_id;
    public InfoInterface $info;

    public function __construct(int $service_id, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.event.created');

        $this->service_id = $service_id;
        $this->info = $info;
    }
}
