<?php

namespace Iranserver\Base;

use Illuminate\Bus\ChainedBatch;
use Illuminate\Foundation\Bus\PendingChain;
use Illuminate\Support\Collection;
use Illuminate\Support\Str;

final class Bus
{
    /**
     * Cont to define position of a job in a chin
     */
    public const JOB_CHAIN_POSITION = [
        'first' => 'FIRST',
        'middle' => 'MIDDLE',
        'last' => 'LAST',
    ];

    /**
     * bus chain simulator which is using to aware service microsys awareness
     *
     * @param Collection|array $jobs
     * @return PendingChain
     */
    final public static function chain(Collection|array $jobs): PendingChain
    {
        $jobs = Collection::wrap($jobs);
        $jobs = ChainedBatch::prepareNestedBatches($jobs);
        $chainUuid = Str::uuid();
        foreach ($jobs as $key => $job) {
            if (method_exists($job, 'setChainAttr')) {

                $position = match ($key) {
                    0 => self::JOB_CHAIN_POSITION['first'],
                    count($jobs) - 1 => self::JOB_CHAIN_POSITION['last'],
                    $key => self::JOB_CHAIN_POSITION['middle']
                };

                $job->setChainAttr($chainUuid , $position);
            }
        }

        return new PendingChain($jobs->shift(), $jobs->toArray());
    }
}
