<?php

namespace Iranserver\Events\Wordpress;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Base\Hosting;
use Iranserver\Models\DTO\HostingDTO;
use Iranserver\Models\Interfaces\HostingInterface;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

class WordpressInstalledEvent extends BaseJob
{
    public Hosting $hosting;
    public ?UserInterface $user;
    public InfoInterface $info;

    /**
     * @var Hosting $hosting
     * @var ?UserInterface $user
     * @var InfoInterface $info
     *
     * Hold invoice parameters.
     */
    public function __construct(Hosting $hosting, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('wordpress.event.installed');

        $this->hosting = $hosting;
        $this->user    = $user;
        $this->info    = $info;
    }
}
