<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\FlavorInterface;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenstackInterface;


class OpenstackServerResizedEvent extends BaseJob
{
    public OpenstackInterface $openstackService;
    public FlavorInterface $oldFlavor;
    public FlavorInterface $newFlavor;
    public InfoInterface $info;

    /**
     * @param OpenstackInterface $openstackService
     * @param FlavorInterface $oldFlavor
     * @param FlavorInterface $newFlavor
     * @param InfoInterface $info
     */
    public function __construct(OpenstackInterface $openstackService, FlavorInterface $oldFlavor, FlavorInterface $newFlavor, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('openstack.event.resized');

        $this->openstackService = $openstackService;
        $this->oldFlavor = $oldFlavor;
        $this->newFlavor = $newFlavor;
        $this->info = $info;
    }
}
