<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\HostingInterface;
use Iranserver\Models\Interfaces\InfoInterface;

class HostingSuspendedEvent extends BaseJob
{
    public HostingInterface $hosting;
    public InfoInterface $info;
    public string $suspension_reason;


    public function __construct(HostingInterface $hosting, string $suspension_reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.event.suspended');

        $this->hosting = $hosting;
        $this->info = $info;
        $this->suspension_reason = $suspension_reason;
    }
}
