<?php

namespace Iranserver\Jobs\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseSuspendHosting extends BaseJob
{
    public int $service_id;
    public InfoInterface $info;
    public string $suspension_reason;

    public $tries = 10;
    public $backoff = 60;

    public function __construct(int $service_id, string $suspension_reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.cmd.suspend');
        $this->service_id = $service_id;
        $this->info = $info;
        $this->suspension_reason = $suspension_reason;

    }

    public function handle()
    {
    }
}