<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseOpenstackInstanceDeleteSnapshot extends BaseJob
{
    public bool $dispatch_from_cron;
    public string $snapshot_id;
    public InfoInterface $info;
    public int $tries = 3;

    public function backoff(): int
    {
        return 60;
    }

    /**
     * @param bool $dispatch_from_cron
     * @param string $snapshot_id
     * @param InfoInterface $info
     */
    public function __construct(bool $dispatch_from_cron, string $snapshot_id, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('snapshot.cmd.delete');

        $this->dispatch_from_cron = $dispatch_from_cron;
        $this->snapshot_id = $snapshot_id;
        $this->info = $info;
    }

    public function handle()
    {
    }
}